<?php
/**
 * 用文字，抒写情感。
 * 
 * @package WriteLove
 * @author Yu Yue
 * @link https://greycat.tk
 */
?>
<html>
  <head>
    <meta charset="<?php $this->options->charset(); ?>">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
<link href="<?php $this->options->themeUrl('index.css'); ?>" rel="stylesheet">
<title><?php $this->archiveTitle(array(
          'category'  =>  _t('分类 %s 下的文章'),
          'search'    =>  _t('包含关键字 %s 的文章'),
          'tag'       =>  _t('标签 %s 下的文章'),
          'author'    =>  _t('%s 发布的文章')
      ), '', ' - '); ?><?php $this->options->title(); ?></title>
<style>
  .ajax_loading_text {
  text-align: center;
  display: none;
  }
  .title {
  text-align: center;
  }
</style>
<style>*{max-width: 100%;}</style>
<script src="//cdn.bootcss.com/jquery/2.2.1/jquery.min.js"></script>
<!-- Load PJAX -->
<script src="//cdn.bootcss.com/jquery.pjax/2.0.1/jquery.pjax.min.js"></script>
<script>
$(document).pjax('a[href^="<?php Helper::options()->siteUrl()?>"]:not(a[target="_blank"], a[no-pjax])', {
    container: '#pjax',
    fragment: '#pjax',
    timeout: 8000
}).on('pjax:send',function() {
$(".ajax_loading_text").css("display", "block");
$(".title").css("display", "none");
}).on('pjax:complete',function() {
$(".ajax_loading_text").css("display", "none");
$(".title").css("display", "block");
});
</script>
</head>
  <body>
    <div class="container">
<div class="header">
      <h1><?php $this->options->title() ?></h1>
      <p><div class="title"><?php if($this->is('archive')):
            $this->archiveTitle(array(
                'category'  =>  _t('分类 %s 下的文章'),
                'search'    =>  _t('包含关键字 %s 的文章'),
                'tag'       =>  _t('标签 %s 下的文章'),
                'author'    =>  _t('%s 发布的文章')
            ), '', '');
            else:
              $this->options->description();
          endif; ?></div><div class="ajax_loading_text">正在加载...</div></p>
</div>
<hr></hr>
<div id="pjax">
<div class="content">
<p style='color:grey;'><a class="article-title" href="<?php $this->permalink() ?>"><?php $this->title() ?></a>&nbsp;「<?php echo formatTime($this->modified); ?>」</p>
<ul><?php $this->content(); ?></ul>
</div>
<hr></hr>
</div>
<p class="copyright">(C) <a href="<?php $this->options->SiteUrl(); ?>"><?php $this->options->title(); ?></a> / Power By <a href="http://typecho.org">typecho</a><br>Theme <a href="//greycat.tk">WriteLove</a> made with ♥</p>
    </div>
  </body>
</html>